*===============================================================================
* Labor market series for France
*===============================================================================
clear all
set more off

cd "$insheet_files/France"

*===============================================================================
* I. data from  French statistical office
* web database (1982-2011)
*===============================================================================

import excel using "Statistical Office 1982-2012", cellrange("A5:Y127") first clear 

collapse (mean) FR*, by(year) //data are currently quarterly

reshape long FR, i(year) j(nuts)

rename FR ue_rate_STAT1_FR

tostring nuts, replace
replace nuts = "FR"+nuts

tempfile FR_labor_1982_2012
save 	 `FR_labor_1982_2012.dta'

*===============================================================================
* II. data from  French statistical office
* pdf file covering 1974-1985
*===============================================================================

import excel using "Statistical office 1974-1985.xlsx", sheet("1980-1985") /// 
	first clear 

reshape long y, i(nuts region_name) j(year)

rename y ue_rate_STAT2_FR

tempfile FR_labor_1980_1985
save 	 `FR_labor_1980_1985.dta'

import excel using "Statistical office 1974-1985.xlsx", sheet("1974-1979") /// 
	first clear 

reshape long y, i(nuts region_name) j(year)

rename y ue_rate_STAT2_FR

merge 1:1 nuts year using `FR_labor_1980_1985.dta', nogen
merge 1:1 nuts year using `FR_labor_1982_2012.dta', nogen

save "$dta_files/FR_labor", replace

